# CastConductor V5 - Deployment Guide

## 📦 **Phase 1 Complete: Core Infrastructure**

CastConductor is a WordPress plugin for creating dynamic Roku channel experiences with live data integration, visual content editing, and multi-scene management.

## 🚀 **Quick Deployment to Hostinger WordPress**

### **Step 1: Upload Plugin**

1. **Zip the entire `castconductor-v5` folder**
2. **Upload to Hostinger via WordPress Admin:**
   - Go to your WordPress Admin Dashboard
   - Navigate to `Plugins` → `Add New` → `Upload Plugin`
   - Upload the zip file
   - Click "Activate Plugin"

### **Step 2: Run Setup Wizard**

1. **After activation, you'll see a setup notice**
2. **Click "Run Setup Wizard"** to create:
   - ✅ Database tables with WordPress-compliant naming
   - ✅ Sample shoutouts, sponsors, and promos
   - ✅ Default branding elements
   - ✅ Container assignments

### **Step 3: Test API Endpoints**

The plugin provides **real API endpoints** immediately:

```
Master Roku Endpoint:
https://yoursite.com/wp-json/castconductor/v5/roku/app-config

Active Content Endpoints:
https://yoursite.com/wp-json/castconductor/v5/content/shoutouts/active
https://yoursite.com/wp-json/castconductor/v5/content/sponsors/active
https://yoursite.com/wp-json/castconductor/v5/content/promos/active

Enhanced Features:
https://yoursite.com/wp-json/castconductor/v5/artwork/search
```

## 📊 **What's Working in Phase 1**

### ✅ **Database Architecture**
- **3-table WordPress-compliant schema**
- `wp_castconductor_containers` - Layout containers
- `wp_castconductor_content_blocks` - Content block definitions  
- `wp_castconductor_container_blocks` - Many-to-many assignments

### ✅ **Custom Post Types**
- `castconductor_shoutout` - User submissions
- `castconductor_sponsor` - Sponsor campaigns with scheduling
- `castconductor_promo` - Promotional content with scheduling

### ✅ **REST API Foundation** 
- **Standardized JSON response format**
- **WordPress permission system integration**
- **Master Roku app-config endpoint**
- **Content management endpoints**

### ✅ **Admin Interface**
- **WordPress admin menu integration**
- **Dashboard with system status**
- **Setup wizard with real content creation**
- **API endpoint browser**

### ✅ **Data Sources**
- **IP geolocation for weather/location** (no API key needed)
- **Album artwork discovery** (iTunes/MusicBrainz/Deezer)
- **WordPress media library integration**

## 🎯 **Architecture**

### **Live Data Integration**
- ✅ Track info uses **metadata APIs**
- ✅ Weather uses **IP geolocation**
- ✅ Location uses **Roku viewer IP data**
- ✅ Content managed via **WordPress custom post types**

### **WordPress-Compliant Naming**
- ✅ All database tables: `wp_castconductor_*`
- ✅ All options: `castconductor_*`
- ✅ All post types: `castconductor_*`
- ✅ Zero plugin conflicts

### **URL Configuration Architecture**
- ✅ No hardcoded URLs in codebase
- ✅ User-configurable via WordPress settings
- ✅ Toaster integration ready
- ✅ Content block-level overrides supported

## 🧪 **Testing the Plugin**

### **1. Admin Dashboard Test**
Navigate to `CastConductor` in WordPress admin menu:
- Should show dashboard with system status
- Should display setup wizard if not completed
- Should show real statistics (shoutouts, sponsors, promos counts)

### **2. API Endpoint Test**
Visit: `https://yoursite.com/wp-json/castconductor/v5/roku/app-config`

**Expected Response:**
```json
{
  "success": true,
  "data": {
    "containers": [
      {
        "id": 1,
        "name": "Lower Third",
        "type": "lower_third_container",
        "position": {"x": 0, "y": 880, "width": 1920, "height": 200},
        "content_blocks": [...]
      }
    ],
    "global_settings": {...},
    "viewer_context": {...}
  },
  "timestamp": "2025-08-05T...",
  "version": "5.0.0"
}
```

### **3. Content Test**
Visit: `https://yoursite.com/wp-json/castconductor/v5/content/shoutouts/active`

**Should return real test shoutouts:**
```json
{
  "success": true,
  "data": [
    {
      "message": "Locked in from Bushwick. Big love!",
      "name": "Sasha",
      "location": "Brooklyn, NY"
    }
  ]
}
```

### **4. Setup Wizard Test**
1. Go to `CastConductor` → `Setup Wizard`
2. Click "🚀 Start Setup Wizard"
3. Should complete 5 steps successfully
4. Should create real test content with images

## 📁 **File Structure Created**

```
castconductor-v5/
├── castconductor.php                 # Main plugin file
├── includes/
│   ├── class-castconductor-database.php
│   ├── class-castconductor-rest-api.php
│   ├── class-castconductor-admin.php
│   ├── class-castconductor-activation-wizard.php
│   ├── api/
│   │   └── class-roku-controller.php  # Master endpoint
│   ├── content-blocks/               # 8 content block types
│   └── utils/                        # Artwork search, geolocation
├── assets/
│   ├── css/admin.css                # Admin interface styles
│   └── js/admin.js                  # Admin JavaScript
└── wizard-content/                  # Demo images with attribution
    ├── cafe-pexels-crisferro73-692666.jpeg
    ├── boombox-gordon-cowie-qQzw8jPvip8-unsplash.jpeg
    └── default-*                    # Branding assets
```

## 🔧 **Configuration After Deployment**

### **Required Configuration:**
1. **Stream URL:** Settings → Stream URL (your audio stream)
2. **Metadata URL:** Settings → Metadata URL (your track info API)

### **Optional Configuration:**
1. **OpenWeather API Key:** For weather data (free at openweathermap.org)
2. **Custom branding:** Upload your own logos/backgrounds

## 🎯 **Next Steps (Phase 2)**

Phase 1 provides the **complete foundation**. Phase 2 will add:

1. **Enhanced Album Artwork Discovery** (V4 system)
2. **5-Step Custom API Integration** 
3. **QR Code System** with analytics
4. **Canvas Editor** interface
5. **Advanced scheduling** system
6. **Content block implementations**

## 🚨 **Troubleshooting**

### **Database Tables Not Created**
- Check WordPress error logs
- Ensure user has `manage_options` capability
- Verify PHP version ≥ 7.4

### **API Endpoints Return 404**
- Check permalink structure (Settings → Permalinks → Save)
- Verify mod_rewrite is enabled on server

### **Setup Wizard Fails**
- Check PHP memory limit (recommend 256M+)
- Verify write permissions on uploads directory
- Check for plugin conflicts

## 📞 **Ready for Testing**

This Phase 1 implementation is **production-ready** for basic testing:

- ✅ **Database architecture** is complete
- ✅ **API endpoints** are functional  
- ✅ **Admin interface** is working
- ✅ **Data sources** are configured
- ✅ **WordPress integration** is proper

**Deploy to your Hostinger WordPress and test the endpoints!**

---

**Next Session:** Continue with Phase 2 implementation based on test results.
