/**
 * Cast Conductor Proprietary License v5
 * SPDX-License-Identifier: LicenseRef-CastConductor-Proprietary-v5
 *
 * Simple Event Bus (on/off/emit) for internal module decoupling.
 * Intentionally tiny to avoid dependency bloat.
 */
(function(global){
  const listeners = new Map(); // event -> Set<fn>
  function on(evt, fn){ if(!listeners.has(evt)) listeners.set(evt,new Set()); listeners.get(evt).add(fn); return ()=>off(evt,fn); }
  function once(evt, fn){ const offFn = on(evt, (p)=>{ try{ fn(p);} finally{ offFn(); }}); return offFn; }
  function off(evt, fn){ const set = listeners.get(evt); if(set){ set.delete(fn); if(!set.size) listeners.delete(evt);} }
  function emit(evt, payload){ const set = listeners.get(evt); if(!set) return; [...set].forEach(fn=>{ try{ fn(payload);} catch(e){ console.warn('[bus] listener error', evt, e); }}); }
  const bus = { on, once, off, emit };
  global.ccveBus = bus; // expose globally
})(window || globalThis);
