/**
 * Cast Conductor Proprietary License v5
 * SPDX-License-Identifier: LicenseRef-CastConductor-Proprietary-v5
 */
const state = {
  currentConfig: null,
  selection: null,
  surface: 'block',
};

export function initState(getDefault){
  if(!state.currentConfig && typeof getDefault === 'function') state.currentConfig = getDefault();
  return state;
}

export function getState(){ return state; }

export function setConfig(cfg){ state.currentConfig = cfg; try { window.ccveBus && window.ccveBus.emit('state:config', { cfg }); } catch {} }
export function updateLayout(patch){
  if(!state.currentConfig) state.currentConfig = { layout:{} };
  const l = state.currentConfig.layout || (state.currentConfig.layout = {});
  Object.assign(l, patch||{});
  try { window.ccveBus && window.ccveBus.emit('geometry:changed', { layout: l }); } catch {}
  return l;
}
export function setSelection(sel){ state.selection = sel; try { window.ccveBus && window.ccveBus.emit('selection:changed', { selection: sel }); } catch {} }
export function setSurface(s){ state.surface = s; try { window.ccveBus && window.ccveBus.emit('surface:changed', { surface: s }); } catch {} }
