/**
 * Cast Conductor Proprietary License v5
 * SPDX-License-Identifier: LicenseRef-CastConductor-Proprietary-v5
 *
 * Design Assets Loader (fonts, sizes, colors) – Phase 2.7 extraction
 */
export async function loadDesignAssets(editor){
  try {
    const response = await fetch(`${castconductorCanvasAjax.rest_url}castconductor/v5/canvas-editor/assets`, {
      method:'GET', headers:{ 'X-WP-Nonce': castconductorCanvasAjax.nonce }
    });
    const data = await response.json();
    if (data.success) editor.populateDesignAssets(data.assets);
  } catch(err){ console.error('Failed to load design assets:', err); }
}

export function populateDesignAssets(editor, assets){
  const fontSelect = document.getElementById('canvas-font-family');
  if (fontSelect && assets.fonts){
    fontSelect.innerHTML='';
    assets.fonts.forEach(font=>{
      const opt=document.createElement('option');
      opt.value=font.value; opt.textContent=font.name; fontSelect.appendChild(opt);
    });
  }
  const fontSizeSelect = document.getElementById('canvas-font-size');
  if (fontSizeSelect && assets.sizes?.font_sizes){
    fontSizeSelect.innerHTML='';
    assets.sizes.font_sizes.forEach(size=>{
      const opt=document.createElement('option');
      opt.value=size; opt.textContent=size+'px'; fontSizeSelect.appendChild(opt);
    });
  }
  editor.designAssets = assets;
}

export const designAssetsApi = { loadDesignAssets, populateDesignAssets };
