/**
 * Cast Conductor Proprietary License v5
 * SPDX-License-Identifier: LicenseRef-CastConductor-Proprietary-v5
 *
 * Simple in-browser event bus (pub/sub) to decouple modules.
 * API: on(event, handler), off(event, handler), emit(event, payload)
 */
export const ccveBus = (function(){
  const map = new Map();
  function on(evt, fn){ if(!map.has(evt)) map.set(evt, new Set()); map.get(evt).add(fn); return ()=>off(evt,fn); }
  function off(evt, fn){ const set = map.get(evt); if(set){ set.delete(fn); if(!set.size) map.delete(evt);} }
  function emit(evt, payload){ const set = map.get(evt); if(set){ for(const fn of [...set]) { try{ fn(payload);}catch(e){ console.warn('[ccveBus] handler error', evt, e);} } } }
  return { on, off, emit };
})();

if (typeof window !== 'undefined') {
  window.ccveBus = window.ccveBus || ccveBus;
}
