/**
 * Cast Conductor Proprietary License v5
 * SPDX-License-Identifier: LicenseRef-CastConductor-Proprietary-v5
 *
 * fetch-utils.js
 * Shared lightweight helpers for safe JSON extraction & standard headers.
 */

export async function safeJson(response) {
  try {
    const json = await response.json();
    // Attach HTTP status info for debugging
    if (!response.ok) {
      console.warn('[fetch-utils] HTTP error:', response.status, response.statusText, json);
      return { success: false, error: `HTTP ${response.status}: ${response.statusText}`, httpStatus: response.status, data: json };
    }
    return json;
  } catch (e) {
    console.error('[fetch-utils] JSON parse failed:', e, 'Response status:', response?.status);
    return { success: false, error: 'Failed to parse response', parseError: e.message };
  }
}

export function stdHeaders() {
    return {
        'Content-Type': 'application/json',
        'X-WP-Nonce': (window.castconductorCanvasAjax||{}).nonce
    };
}
