/**
 * Cast Conductor Proprietary License v5
 * SPDX-License-Identifier: LicenseRef-CastConductor-Proprietary-v5
 * Preferences Store Module (Phase 2.7)
 * Wraps scattered localStorage gets/sets with safe helpers & namespacing.
 */
const PREFIX = 'ccve_';
function k(s){ return PREFIX + s; }

export function prefSet(key, value){ try { localStorage.setItem(k(key), JSON.stringify({ v:value, t:Date.now() })); } catch(_){} }
export function prefGet(key, fallback=null){ try { const raw=localStorage.getItem(k(key)); if(!raw) return fallback; const obj=JSON.parse(raw); return (obj && 'v' in obj) ? obj.v : fallback; } catch(_){ return fallback; } }
export function prefRemove(key){ try { localStorage.removeItem(k(key)); } catch(_){} }
export function prefHas(key){ try { return !!localStorage.getItem(k(key)); } catch(_){ return false; } }

export const preferencesStore = { set:prefSet, get:prefGet, remove:prefRemove, has:prefHas };
