/* Rulers Module (Overlay Implementation - Restored)
 * Restored original absolutely-positioned overlay rulers (pre grid refactor).
 * Provides horizontal & vertical pixel rulers without altering layout flow.
 */
export function initRulers(frame, logicalW=1280, logicalH=720) {
  if (!frame) return null;
  // Use / create a dedicated scale host wrapper that contains stage + rulers overlay
  let host = frame.querySelector('.ccve-scale-host');
  if (!host) {
    host = document.createElement('div');
    host.className = 'ccve-scale-host';
    const stageOuter = frame.querySelector('.ccve-stage-outer');
    if (stageOuter) host.appendChild(stageOuter);
    // Insert at top so rulers can absolutely position relative within
    frame.insertBefore(host, frame.firstChild);
  }
  // Ensure individual ruler elements exist
  let h = host.querySelector('.ccve-ruler-horizontal');
  let v = host.querySelector('.ccve-ruler-vertical');
  let c = host.querySelector('.ccve-ruler-corner');
  if (!h) { h = document.createElement('div'); h.className='ccve-ruler-horizontal'; host.appendChild(h); }
  if (!v) { v = document.createElement('div'); v.className='ccve-ruler-vertical'; host.appendChild(v); }
  if (!c) { c = document.createElement('div'); c.className='ccve-ruler-corner'; host.appendChild(c); }
  // Force absolute positioning (defensive in case of stylesheet drift)
    h.style.position='absolute'; v.style.position='absolute'; c.style.position='absolute';
    h.style.pointerEvents='none'; v.style.pointerEvents='none'; c.style.pointerEvents='none';
    h.style.zIndex = '50'; v.style.zIndex = '50'; c.style.zIndex = '50';
    // Fix host intrinsic size to logical stage to prevent any size change when enabling rulers
    host.style.width = logicalW + 'px';
    host.style.height = logicalH + 'px';
    // Size & position rulers in a fixed gutter, keeping stage fully inside rulers
    // Keep in sync with CSS var --ccve-ruler-thickness (24px default)
  const cs = getComputedStyle(document.documentElement);
  const varThickness = parseInt(cs.getPropertyValue('--ccve-ruler-thickness')||'24', 10);
  const thickness = Number.isFinite(varThickness) && varThickness > 0 ? varThickness : 24; // px
    const applyFrame = () => {
      // Host accounts for gutter
      host.style.width = (logicalW + thickness) + 'px';
      host.style.height = (logicalH + thickness) + 'px';
      // Rulers
      h.style.left = thickness + 'px';
      h.style.top = '0px';
      h.style.width = logicalW + 'px';
      h.style.height = thickness + 'px';
      v.style.left = '0px';
      v.style.top = thickness + 'px';
      v.style.width = thickness + 'px';
      v.style.height = logicalH + 'px';
      c.style.left = '0px';
      c.style.top = '0px';
      c.style.width = thickness + 'px';
      c.style.height = thickness + 'px';
      // Offset stage into gutter if present
      const stage = host.querySelector('.ccve-stage-outer');
      if (stage) { stage.style.left = thickness + 'px'; stage.style.top = thickness + 'px'; }
    };
    applyFrame();
  const api = {
    logicalW, logicalH,
    updateBounds(w, hgt) { if (typeof w==='number'&&typeof hgt==='number'){ this.logicalW=w; this.logicalH=hgt; logicalW=w; logicalH=hgt; applyFrame(); this.renderTicks(); } },
    renderTicks() {
      if (!h || !v) return; h.innerHTML=''; v.innerHTML='';
      const minorStep = 20; const majorStep = 100;
      for (let x=0; x<=logicalW; x+=minorStep) {
        const major = x % majorStep === 0;
        const tick = document.createElement('div');
        tick.className='ccve-ruler-tick';
        tick.style.left = x + 'px';
        tick.style.height = major ? '100%' : '45%';
        tick.style.width='1px';
        tick.style.bottom='0';
        h.appendChild(tick);
        if (major) {
          const lbl=document.createElement('div');
            lbl.textContent=String(x);
            lbl.style.position='absolute';
            lbl.style.left=(x+2)+'px';
            lbl.style.top='2px';
            h.appendChild(lbl);
        }
      }
      for (let y=0; y<=logicalH; y+=minorStep) {
        const major = y % majorStep === 0;
        const tick=document.createElement('div');
        tick.className='ccve-ruler-tick';
        tick.style.top = y + 'px';
        tick.style.width = major ? '100%' : '45%';
        tick.style.height='1px';
        tick.style.right='0';
        v.appendChild(tick);
        if (major) {
          const lbl=document.createElement('div');
            lbl.textContent=String(y);
            lbl.style.position='absolute';
            lbl.style.top=(y+2)+'px';
            lbl.style.left='2px';
            v.appendChild(lbl);
        }
      }
    },
      setVisible(on) { if (h&&v&&c) { const val = !!on ? 'visible' : 'hidden'; h.style.visibility = val; v.style.visibility = val; c.style.visibility = val; } if (host) host.classList.toggle('rulers-active', !!on); },
    destroy() { if (h) h.remove(); if (v) v.remove(); if (c) c.remove(); h=v=c=null; }
  };
  api.renderTicks();
  return api;
}
