/**
 * Cast Conductor Proprietary License v5
 * SPDX-License-Identifier: LicenseRef-CastConductor-Proprietary-v5
 *
 * Deterministic seed + hash utilities – Phase 2.7 extraction
 */
export function simpleHash(str){
  let h = 2166136261 >>> 0;
  for (let i=0;i<str.length;i++){ h ^= str.charCodeAt(i); h = Math.imul(h,16777619); }
  return (h>>>0);
}

export function getDeterministicSeed(editor){
  if (editor._deterministicSeed) return editor._deterministicSeed;
  try {
    const key='cc_preview_seed';
    let seed = window.localStorage?.getItem(key);
    if (!seed){
      const base = `${window.location.host}|${Date.now()}`;
      seed = String(simpleHash(base));
      window.localStorage?.setItem(key, seed);
    }
    editor._deterministicSeed = seed; return seed;
  } catch(_){
    editor._deterministicSeed = String(Date.now());
    return editor._deterministicSeed;
  }
}

export const seedUtils = { simpleHash, getDeterministicSeed };
