/** Batch Export Modal (Optional Enhancement) */
import { extractTokens as _extract } from './token-parser.js';
export function openTokenBatchExportModal(editor){
  if(!editor || typeof editor.showModal!=='function') return;
  const list = (window.ccveContentBlocksListCache || []).slice(0,100); // rely on cached list if present
  const html = `
  <style>.tbexp-wrap{font:12px system-ui,Arial;display:flex;flex-direction:column;gap:8px;max-height:420px;}.tbexp-list{border:1px solid #334155;padding:6px;overflow:auto;max-height:200px;background:#0f172a;color:#e2e8f0}.tbexp-list label{display:flex;align-items:center;gap:6px;padding:2px 0;}.tbexp-actions{display:flex;justify-content:space-between;margin-top:6px}.tbexp-btn{background:#2563eb;color:#fff;border:1px solid #1d4ed8;padding:4px 10px;border-radius:4px;cursor:pointer;font-size:12px;font-weight:600;} .tbexp-close{background:#64748b;color:#fff;border:1px solid #475569;padding:4px 10px;border-radius:4px;cursor:pointer;font-size:12px;} textarea.tbexp-out{width:100%;min-height:160px;font:11px monospace;background:#0f172a;color:#e2e8f0;border:1px solid #334155;padding:6px}</style>
  <div class="tbexp-wrap" id="ccve-token-batch-export-modal">
    <div><strong>Select content blocks (token layers serialized)</strong></div>
    <div class="tbexp-list">${list.map(cb=>`<label><input type=checkbox value="${cb.id}"> ${cb.id} – ${cb.name||cb.title||'Block'}</label>`).join('') || 'No list cached.'}</div>
    <button type=button class="tbexp-btn" id="tbexp-generate">Generate JSON</button>
    <textarea class="tbexp-out" id="tbexp-output" placeholder="Combined export JSON appears here" readonly></textarea>
    <div class="tbexp-actions"><button type=button class="tbexp-close">Close</button></div>
  </div>`;
  editor.showModal('Batch Export Token Layers', html);
  const root=document.getElementById('ccve-token-batch-export-modal'); if(!root) return;
  root.querySelector('.tbexp-close').addEventListener('click', ()=>editor.closeModal());
  root.querySelector('#tbexp-generate').addEventListener('click', async ()=>{
    const ids = Array.from(root.querySelectorAll('input[type=checkbox]:checked')).map(i=>parseInt(i.value,10)).filter(Boolean);
    if(!ids.length){ return; }
    const results=[];
    for(const id of ids){
      try {
        const resp = await fetch(`/wp-json/castconductor/v5/content-blocks/${id}`);
        if(!resp.ok) continue; const data = await resp.json();
        const vc = data?.data?.visual_config || {}; const tokenLayers = vc.token_layers || [];
        if(tokenLayers.length){ results.push({ content_block_id:id, layers: tokenLayers }); }
      } catch(_){}
    }
    root.querySelector('#tbexp-output').value = JSON.stringify({ blocks: results }, null, 2);
  });
}
export default { openTokenBatchExportModal };
