/** Token Status Modal: lists tokens missing data */
export function openTokenStatusModal(editor){
  if(!editor || typeof editor.showModal!=='function') return;
  const rows=[];
  if(editor.currentConfig && Array.isArray(editor.currentConfig.layers)){
    editor.currentConfig.layers.forEach(l=>{
      if(!l) return; if(l.kind==='token-text'){ if(!l.renderedText||!l.renderedText.trim()) rows.push({ id:l.id, type:'text', detail:'empty output' }); }
      if(l.kind==='token-image'){ if(!l.renderedUrl) rows.push({ id:l.id, type:'image', detail:'no image URL' }); }
    });
  }
  const html=`<style>.tstat-wrap{font:12px system-ui,Arial;display:flex;flex-direction:column;gap:8px;}.tstat-table{border-collapse:collapse;width:100%;font-size:12px}.tstat-table th,.tstat-table td{border:1px solid #334155;padding:4px 6px;text-align:left;} .tstat-none{color:#16a34a;font-weight:600} .tstat-close{background:#64748b;color:#fff;border:1px solid #475569;padding:4px 10px;border-radius:4px;cursor:pointer;font-size:12px;align-self:flex-end}</style>
  <div class='tstat-wrap' id='ccve-token-status-modal'>
    <div><strong>Token Layer Status</strong></div>
    ${rows.length?`<table class='tstat-table'><thead><tr><th>Layer ID</th><th>Kind</th><th>Issue</th></tr></thead><tbody>${rows.map(r=>`<tr><td>${r.id}</td><td>${r.type}</td><td>${r.detail}</td></tr>`).join('')}</tbody></table>`:`<div class='tstat-none'>All token layers have output.</div>`}
    <button type='button' class='tstat-close'>Close</button>
  </div>`;
  editor.showModal('Token Status', html);
  document.querySelector('#ccve-token-status-modal .tstat-close')?.addEventListener('click',()=>editor.closeModal());
}
export default { openTokenStatusModal };
