/**
 * Cast Conductor Proprietary License v5
 * SPDX-License-Identifier: LicenseRef-CastConductor-Proprietary-v5
 */
export function stableHash(obj){
  try { return JSON.stringify(obj || {}); } catch { return ''; }
}

export function layoutSubset(config){
  const c = config || {}; const l = c.layout || {};
  return {
    type: c.content_block_type || c.type || null,
    layout: {
      x: l.x_position ?? l.x ?? l.position?.x ?? 0,
      y: l.y_position ?? l.y ?? l.position?.y ?? 0,
      w: l.width ?? l.w ?? 0,
      h: l.height ?? l.h ?? 0,
      responsive: l.responsive || null,
      padding: l.padding || null
    },
    visuals: c.background || null
  };
}
