/**
 * Cast Conductor Proprietary License v5
 * SPDX-License-Identifier: LicenseRef-CastConductor-Proprietary-v5
 */
export const PRESET_GEOMETRY = Object.freeze({
  lower_third: { w:1280,h:240,x:0,y:720-240 },
  upper_third: { w:1280,h:240,x:0,y:0 },
  center_third: { w:1280,h:240,x:0,y:Math.floor((720-240)/2) },
  full_screen: { w:1280,h:720,x:0,y:0 },
  left_half: { w:640,h:720,x:0,y:0 },
  right_half: { w:640,h:720,x:640,y:0 },
  top_half: { w:1280,h:360,x:0,y:0 },
  bottom_half: { w:1280,h:360,x:0,y:720-360 },
  upper_left_quarter: { w:640,h:360,x:0,y:0 },
  upper_right_quarter: { w:640,h:360,x:640,y:0 },
  lower_left_quarter: { w:640,h:360,x:0,y:360 },
  lower_right_quarter: { w:640,h:360,x:640,y:360 },
  horizontal_upper_half: { w:1280,h:360,x:0,y:0 },
  horizontal_lower_half: { w:1280,h:360,x:0,y:360 },
  // Horizontal Quarters (1280×180 strips)
  horizontal_first_quarter: { w:1280,h:180,x:0,y:0 },
  horizontal_second_quarter: { w:1280,h:180,x:0,y:180 },
  horizontal_third_quarter: { w:1280,h:180,x:0,y:360 },
  horizontal_fourth_quarter: { w:1280,h:180,x:0,y:540 },
  // Featured + Grid (hero 1280×480 + 4 grid items 320×240 below)
  featured_grid_hero: { w:1280,h:480,x:0,y:0 },
  featured_grid_item_1: { w:320,h:240,x:0,y:480 },
  featured_grid_item_2: { w:320,h:240,x:320,y:480 },
  featured_grid_item_3: { w:320,h:240,x:640,y:480 },
  featured_grid_item_4: { w:320,h:240,x:960,y:480 }
});

export function normalizePresetKey(key){
  return String(key||'').toLowerCase().replace(/\s+/g,'_').replace(/-/g,'_');
}
