<?php
/**
 * Cast Conductor Proprietary License v5
 * SPDX-License-Identifier: LicenseRef-CastConductor-Proprietary-v5
 * 
 * Copyright (c) 2025 CastConductor.com. All Rights Reserved.
 * 
 * This file is part of Cast Conductor ("Software"). The Software and its source
 * code constitute proprietary, confidential, and trade secret information of
 * CastConductor.com ("Company"). Any access or use is governed strictly by the
 * Cast Conductor Proprietary License v5 ("License"). By installing, copying,
 * accessing, compiling, or otherwise using the Software you agree to be bound by
 * all terms of the License. If you do not agree, you must cease use immediately.
 * 
 * Key Terms (Summary – see full License for binding terms):
 *  1. No Redistribution: You may not publish, distribute, sublicense, rent,
 *     lease, transfer, sell, or otherwise make the Software (or any derivative)
 *     available to any third party without prior written consent of Company.
 *  2. No Modification: Modification, reverse engineering, decompilation, or
 *     disassembly is prohibited except to the limited extent expressly permitted
 *     by applicable law that cannot be contractually waived.
 *  3. Confidentiality: Treat all source code and related artifacts as Company
 *     Confidential Information. Maintain at least the same degree of care as for
 *     your own confidential materials, and not less than reasonable care.
 *  4. No Patent License: No express or implied patent rights are granted. Future
 *     patents (if any) are fully reserved.
 *  5. No Trademark License: Company names, marks, and logos may not be used
 *     without prior written permission.
 *  6. Limited Internal Use: Use is limited solely to internal evaluation and
 *     operation of licensed Cast Conductor deployments. Commercial hosting or
 *     resale as a service requires a separate written agreement.
 *  7. Telemetry & License Validation: The Software may periodically transmit a
 *     hashed installation identifier, domain (or site ID), plugin/app version,
 *     and a truncated (non-reversible) fragment of the license key solely to
 *     validate activation status and enforce licensing. This minimal "phone home"
 *     check contains no personal or content data. If optional telemetry is later
 *     introduced it will be limited to aggregate operational metrics (no PII),
 *     fully documented, and optionally disableable per published instructions.
 *  8. Third-Party Components: The Software may include open source components
 *     covered by their own licenses. See THIRD-PARTY-NOTICES.md. Those licenses
 *     govern their respective components; this License governs all remaining code.
 *  9. Export Compliance: You are responsible for compliance with all applicable
 *     export control and sanctions laws.
 * 10. Warranty Disclaimer: THE SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF
 *     ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO MERCHANTABILITY,
 *     FITNESS FOR A PARTICULAR PURPOSE, TITLE, AND NON-INFRINGEMENT.
 * 11. Limitation of Liability: IN NO EVENT WILL COMPANY OR AUTHORS BE LIABLE FOR
 *     ANY INDIRECT, SPECIAL, INCIDENTAL, CONSEQUENTIAL, EXEMPLARY, OR PUNITIVE
 *     DAMAGES, OR LOST PROFITS, EVEN IF ADVISED OF THE POSSIBILITY.
 * 12. Acceptance: Use of the Software constitutes acceptance of the License.
 * 13. Enforcement: Unauthorized reproduction or distribution may result in civil
 *     and criminal penalties and will be prosecuted to the maximum extent allowed
 *     by law.
 * 
 * Authoritative EULA: EULA-v5.1.md (repository root – private) and https://castconductor.com/eula
 * Precedence: If this summary conflicts with the EULA, the EULA governs.
 * Revision: Current EULA revision v5.1 (subject to update; check EULA for current enterprise thresholds).
 * 
 * Full License text available from: licensing@castconductor.com
 * Security reports: security@castconductor.com
 * Commercial inquiries: licensing@castconductor.com
 * 
 * END OF HEADER
 */

/**
 * Base Content Block (Universal Template)
 *
 * Provides standardized geometry, fitMode, intendedContainer, visual styling, and behavior fields.
 * All future content blocks should extend this class.
 */

if (!defined('ABSPATH')) {
    exit;
}

class CastConductor_Base_Block {
    /**
     * Block type identifier (should be set by child classes)
     */
    public $type = 'base';

    /**
     * Display name (should be set by child classes)
     */
    public $display_name = 'Base Block';

    /**
     * Description (should be set by child classes)
     */
    public $description = 'Universal base block template for all content blocks.';

    /**
     * Universal block schema
     */
    public function get_field_schema() {
        return [
            'geometry' => [
                'type' => 'group',
                'label' => 'Geometry',
                'fields' => [
                    'x' => [ 'type' => 'number', 'label' => 'X', 'default' => 0, 'unit' => 'px|%' ],
                    'y' => [ 'type' => 'number', 'label' => 'Y', 'default' => 0, 'unit' => 'px|%' ],
                    'width' => [ 'type' => 'number', 'label' => 'Width', 'default' => 400, 'unit' => 'px|%' ],
                    'height' => [ 'type' => 'number', 'label' => 'Height', 'default' => 100, 'unit' => 'px|%' ],
                    'mode' => [ 'type' => 'select', 'label' => 'Sizing Mode', 'default' => 'absolute', 'options' => [ 'absolute' => 'Absolute (px)', 'relative' => 'Relative (%)' ] ],
                ]
            ],
            'fitMode' => [
                'type' => 'select',
                'label' => 'Fit Mode',
                'default' => 'fill',
                'options' => [
                    'fill' => 'Fill',
                    'contain' => 'Contain',
                    'cover' => 'Cover',
                    'maintain-aspect' => 'Maintain Aspect',
                    'anchor' => 'Anchor'
                ]
            ],
            'intendedContainer' => [
                'type' => 'select',
                'label' => 'Intended Container',
                'default' => 'lower_third',
                'options' => [
                    'lower_third' => 'Lower Third',
                    'upper_third' => 'Upper Third',
                    'full_screen' => 'Full Screen',
                    'left_half' => 'Left Half',
                    'right_half' => 'Right Half',
                    'upper_left_quarter' => 'Upper Left Quarter',
                    'upper_right_quarter' => 'Upper Right Quarter',
                    'lower_left_quarter' => 'Lower Left Quarter',
                    'lower_right_quarter' => 'Lower Right Quarter',
                    'horizontal_upper_half' => 'Horizontal Upper Half',
                    'horizontal_lower_half' => 'Horizontal Lower Half'
                ]
            ],
            'visual' => [
                'type' => 'group',
                'label' => 'Visual Styling',
                'fields' => [
                    'background_color' => [ 'type' => 'color', 'label' => 'Background Color', 'default' => '#000000' ],
                    'text_color' => [ 'type' => 'color', 'label' => 'Text Color', 'default' => '#ffffff' ],
                    'border_radius' => [ 'type' => 'number', 'label' => 'Border Radius (px)', 'default' => 0 ],
                    'shadow_enabled' => [ 'type' => 'checkbox', 'label' => 'Enable Shadow', 'default' => false ]
                ]
            ],
            'behavior' => [
                'type' => 'group',
                'label' => 'Behavior',
                'fields' => [
                    'marquee' => [ 'type' => 'checkbox', 'label' => 'Enable Marquee', 'default' => false ],
                    'animation' => [ 'type' => 'checkbox', 'label' => 'Enable Animation', 'default' => false ]
                ]
            ],
            'content' => [
                'type' => 'group',
                'label' => 'Content',
                'fields' => [
                    'text' => [ 'type' => 'text', 'label' => 'Text', 'default' => '' ],
                    'image_url' => [ 'type' => 'text', 'label' => 'Image URL', 'default' => '' ]
                ]
            ]
        ];
    }
    /**
     * Fetch live data for this block type
     * 
     * @param array $data_config Configuration for data source
     * @return array Data structure for rendering
     */
    public function fetch_data($data_config) {
        return []; // Default empty, to be overridden by child classes
    }

    /**
     * Fetch list of live data items for this block type (for rotation/slideshows)
     * 
     * @param array $data_config Configuration for data source
     * @param int $limit Maximum number of items to fetch
     * @return array List of data structures for rendering
     */
    public function fetch_items($data_config, $limit = 20) {
        return []; // Default empty
    }
}
