<?php
// Simple quick test for reflow engine

require_once __DIR__ . '/../includes/class-castconductor-reflow-engine.php';

echo "=== Smart Reflow Engine Quick Test ===\n\n";

// Test 1: needsReflow
echo "1. Testing needsReflow():\n";
$r1 = CastConductor_Reflow_Engine::needs_reflow(1280, 240, 640, 360);
echo "   1280x240 → 640x360: " . ($r1 ? "YES" : "NO") . " (expected: YES)\n";

$r2 = CastConductor_Reflow_Engine::needs_reflow(1280, 240, 1280, 240);
echo "   1280x240 → 1280x240: " . ($r2 ? "YES" : "NO") . " (expected: NO)\n";

$r3 = CastConductor_Reflow_Engine::needs_reflow(1280, 720, 640, 360);
echo "   1280x720 → 640x360: " . ($r3 ? "YES" : "NO") . " (expected: NO - same ratio)\n";

// Test 2: Layout mode detection
echo "\n2. Testing getReflowLayoutMode():\n";
$m1 = CastConductor_Reflow_Engine::get_reflow_layout_mode(1280, 240, 640, 360);
echo "   1280x240 → 640x360: $m1 (expected: vertical-stack)\n";

$m2 = CastConductor_Reflow_Engine::get_reflow_layout_mode(640, 360, 1280, 240);
echo "   640x360 → 1280x240: $m2 (expected: horizontal-spread)\n";

$m3 = CastConductor_Reflow_Engine::get_reflow_layout_mode(800, 600, 640, 480);
echo "   800x600 → 640x480: $m3 (expected: proportional)\n";

// Test 3: Calculate reflow
echo "\n3. Testing calculateReflowLayout():\n";
$layers = [
    [
        'id' => 'layer1',
        'kind' => 'token-image',
        'x' => 16,
        'y' => 20,
        'width' => 200,
        'height' => 200,
    ],
    [
        'id' => 'layer2',
        'kind' => 'token-text',
        'x' => 232,
        'y' => 50,
        'width' => 500,
        'height' => 60,
        'style' => ['font_size' => 36],
    ],
];

$result = CastConductor_Reflow_Engine::calculate_reflow_layout($layers, 1280, 240, 640, 360);

echo "   Input: 2 layers, 1280x240 → 640x360\n";
echo "   Result:\n";
foreach ($result as $i => $layer) {
    if (isset($layer['_reflow'])) {
        $r = $layer['_reflow'];
        echo "     Layer $i: x={$r['x']}, y={$r['y']}, w={$r['width']}, h={$r['height']}";
        if (isset($r['fontSize'])) echo ", fontSize={$r['fontSize']}";
        echo "\n";
    } else {
        echo "     Layer $i: (no reflow applied)\n";
    }
}

echo "\n=== Test Complete ===\n";
